/* Custom javascript 详细介绍请查看官方文档
 * @param {Object} params
 * @property {Array} params.axes  chart options中的轴配置，与拖入的轴对应
 * @property {Object} params.data  接口返回的数据，与轴对应
 * @property {Array} params.data.data 接口返回的原始数据
 * @property {Array} params.data.schema 这里包含了初步加工过的数据，其中的dataUniq是去重并按照配置排好序的
 * @property {number} params.width  容器的宽度
 * @property {number} params.height 容器的高度
 * @property {Function} params.getD3 获取d3工具库, 当前版本7.0.1
 * @property {Function} params.getEcharts 获取echarts，当前版本是4.9，用于写扩展
 * @property {Function} params.useEchartsGL 加载echartsGL, 1.1.2版本
 * @property {Function} params.getThree 获取three.js，当前版本0.132.2
 * @property {Function} params.getTween 获取tween.js，当前版本18.6.4
 * @property {Function} params.createElement 生成一个DOM
 * @property {Function} params.appendChild 向容器添加DOM
 * @property {Function} params.getParentDOM 获取DOM的父元素
 * @property {Function} params.setInnerHTML 设置容器的innerHTML
 * @property {Function} params.bindClickListener 绑定页面点击事件
 * @property {Function} params.onHSClickHandler 触发衡石交互
 * @property {Function} params.getContext 获取canvas的context
 * @property {Object=} params.currentHighlight 当前高亮项
 * @property {Function} params.bindUnmountHandler 绑定卸载时执行的方法，比如卸载组件，清除setTimeout等
 * @property {Array<clickEventData>=} params.currentHighlight.clickEventData 当前高亮项对应的数据
 */
console.log(params);

var axes = params.axes;
if (!axes || axes.length !== 3 || axes[0].axisName !== 'group' || axes[1].axisName !== 'group' || axes[2].axisName !== 'metric'
  || axes[2].op === 'perceive' && axes[2].args[1].axisName === 'subgroup') {
  // 如果不是一个维度一个度量，提示
  params.setInnerHTML('<div style="text-align:center;line-height:' + params.height + 'px;">'
  +    '<span>此图表只支持2个维度和1个度量（无对比维度）的配置，请在配置区编辑</span>'
  +  '</div>'
  );
  return;
}

params.useEchartsGL();
var myChart = params.getEchartsItem();

// 轴文字颜色
var axisLabel = {
  color: '#666'
};
// 轴线条颜色
var axisLine = {
  lineStyle: {
    color: '#666'
  },
};

myChart.setOption({
  visualMap: {
    max: params.data.schema[2].max,
    inRange: {
      color: ['#313695', '#4575b4', '#74add1', '#abd9e9', '#e0f3f8', '#ffffbf', '#fee090', '#fdae61', '#f46d43', '#d73027', '#a50026']
    }
  },
  xAxis3D: {
    type: 'category',
    data: params.data.schema[0].dataUniq,
    axisLabel: axisLabel,
    axisLine: axisLine,
  },
  yAxis3D: {
    type: 'category',
    data: params.data.schema[1].dataUniq,
    axisLabel: axisLabel,
    axisLine: axisLine,
  },
  zAxis3D: {
    type: 'value',
    axisLabel: axisLabel,
    axisLine: axisLine,
  },
  grid3D: {},
  series: [{
    data: params.data.data,
    type: 'bar3D'
  }]
});

myChart.on('click', function (option) {
  params.onHSClickHandler([{
    data: option.value[0],
    path: 0,
  }, {
    data: option.value[1],
    path: 1,
  }])
});

/**
 * @typedef {Object} clickOptions
 * @property {string} className  点击事件的当前元素的className
 * @property {string} id 点击事件的当前元素的id
 * @property {number} x 当前鼠标在容器中的横向相对位置
 * @property {number} y 当前鼠标在容器中的纵向相对位置
 * @property {string} data 当前元素的data属性
 */

/**
 * @type {Function} params.bindClickListener 绑定页面点击事件
 * @param {Function} clickHandler 点击页面的处理函数，接收一个参数clickOptions
 */

/**
 * @typedef ClickEventData
 * @param {string} data 维度值
 * @param {string | number} path 维度值对应的轴位置，例：0（第一个轴）； '1.1' (第二个轴的第二个子轴)
 */

/**
 * @type {Function} params.onHSClickHandler 触发衡石交互
 * @param {Array<clickEventData>} clickData 需要传递的数据
 */
