/* Custom javascript 详细介绍请查看官方文档
 * @param {Object} params
 * @property {Array} params.axes  chart options中的轴配置，与拖入的轴对应
 * @property {Object} params.data  接口返回的数据，与轴对应
 * @property {Array} params.data.data 接口返回的原始数据
 * @property {Array} params.data.schema 这里包含了初步加工过的数据，其中的dataUniq是去重并按照配置排好序的
 * @property {number} params.width  容器的宽度
 * @property {number} params.height 容器的高度
 * @property {Object} params.chartConf chart的颜色、大小、文字、提示的配置
 * @property {Function} params.getD3 获取d3工具库, 当前版本7.0.1
 * @property {Function} params.getEcharts 获取echarts，当前版本是5，用于写扩展
 * @property {Function} params.useEchartsGL 加载echartsGL, 1.1.2版本
 * @property {Function} params.getThree 获取three.js，当前版本0.132.2
 * @property {Function} params.getTween 获取tween.js，当前版本18.6.4
 * @property {Function} params.createElement 生成一个DOM
 * @property {Function} params.appendChild 向容器添加DOM
 * @property {Function} params.getParentDOM 获取DOM的父元素
 * @property {Function} params.setInnerHTML 设置容器的innerHTML
 * @property {Function} params.bindClickListener 绑定页面点击事件
 * @property {Function} params.onHSClickHandler 触发衡石交互
 * @property {Function} params.getContext 获取canvas的context
 * @property {Object=} params.currentHighlight 当前高亮项
 * @property {Function} params.bindUnmountHandler 绑定卸载时执行的方法，比如卸载组件，清除setTimeout等
 * @property {Array<clickEventData>=} params.currentHighlight.clickEventData 当前高亮项对应的数据
 */
console.log(params);

var axes = params.axes;
if (!axes || axes.length !== 3 || axes[1].axisName !== 'group' || axes[2].axisName !== 'metric'
  || axes[2].op === 'perceive' && axes[2].args[1].axisName === 'subgroup') {
  // 如果不是一个维度一个度量，提示
  params.setInnerHTML('<div style="text-align:center;line-height:' + params.height + 'px;">'
  +    '<span>此图表只支持2个维度和1个度量（无对比维度）的配置，请在配置区编辑</span>'
  +  '</div>'
  );
  return;
}

var myChart = params.getEchartsItem();
var dataHash = {};
var years = [];
var year;
var country;
var colorHash = {};
var colorIndex = 0;

for (var i = 0; i < params.data.data.length; i++) {
  year = params.data.data[i][1];
  country = params.data.data[i][0];
  if (!dataHash[year]) {
    years.push(year);
    dataHash[year] = [];
  }
  if (!colorHash[country]) {
    colorHash[country] = params.chartConf.color[colorIndex % params.chartConf.color.length];
    colorIndex++;
  }
  dataHash[year].push(params.data.data[i]);
}
var option = {
  grid: {
    top: 10,
    bottom: 30,
    left: 150,
    right: 80
  },
  xAxis: {
      max: 'dataMax',
      axisLabel: {
        formatter: function (n) {
          return Math.round(n) + '';
        }
      }
    },
  yAxis: {
      type: 'category',
      inverse: true,
      max: 10,
      axisLabel: {
        show: true,
        fontSize: 14,
      },
      animationDuration: 300,
      animationDurationUpdate: 300
    },
  series: [
      {
        realtimeSort: true,
        seriesLayoutBy: 'column',
        type: 'bar',
        itemStyle: {
          color: function (param) {
            return colorHash[param.value[0]] || '#5470c6';
          }
        },
        data: dataHash[years[0]],
        encode: {
          x: 2,
          y: 0
        },
        label: {
          show: true,
          precision: 1,
          position: 'right',
          valueAnimation: true,
          fontFamily: 'monospace'
        }
      }
    ],
  // Disable init animation.
  animationDuration: 0,
  animationDurationUpdate: 2000,
  animationEasing: 'linear',
  animationEasingUpdate: 'linear'
};

myChart.setOption(option);

var timer;
function updateYear(index) {
  option.series[0].data = dataHash[years[index]];
  myChart.setOption(option);
  if (index < years.length - 1) {
    timer = setTimeout(function () {
       updateYear(index + 1);
    }, 2000);
  }
}

timer = setTimeout(function () {
   updateYear(1);
}, 2000);

params.bindUnmountHandler(function () {
  clearTimeout(timer);
});