/* Custom javascript 详细介绍请查看官方文档
 * @param {Object} params
 * @property {Array} params.axes  chart options中的轴配置，与拖入的轴对应
 * @property {Object} params.data  接口返回的数据，与轴对应
 * @property {Array} params.data.data 接口返回的原始数据
 * @property {Array} params.data.schema 这里包含了初步加工过的数据，其中的dataUniq是去重并按照配置排好序的
 * @property {number} params.width  容器的宽度
 * @property {number} params.height 容器的高度
 * @property {Function} params.getD3 获取d3工具库, 当前版本7.0.1
 * @property {Function} params.getEcharts 获取echarts，当前版本是4.9，用于写扩展
 * @property {Function} params.getThree 获取three.js，当前版本0.132.2
 * @property {Function} params.getTween 获取tween.js，当前版本18.6.4
 * @property {Function} params.createElement 生成一个DOM
 * @property {Function} params.appendChild 向容器添加DOM
 * @property {Function} params.getParentDOM 获取DOM的父元素
 * @property {Function} params.setInnerHTML 设置容器的innerHTML
 * @property {Function} params.bindClickListener 绑定页面点击事件
 * @property {Function} params.onHSClickHandler 触发衡石交互
 * @property {Function} params.getContext 获取canvas的context
 * @property {Object=} params.currentHighlight 当前高亮项
 * @property {Array<clickEventData>=} params.currentHighlight.clickEventData 当前高亮项对应的数据
 */
console.log(params);

var axes = params.axes;


/*  该图标不对维度和度量进行限制
if (!axes  || axes[0].axisName !== 'group' || axes[1].axisName !== 'metric') {
  // 如果不是一个维度一个度量，提示
  params.setInnerHTML('<div style="text-align:center;line-height:' + params.height + 'px;">'
  +    '<span>此图表只支持1个维度和1个度量的配置，请在配置区编辑</span>'
  +  '</div>'
  );
  return;
}
*/

var myChart = params.getEchartsItem();

/*uniq 该函数对数组进行去重  */
function uniq(array){
    var temp = []; //一个新的临时数组
    for(var i = 0; i < array.length; i++){
        if(temp.indexOf(array[i]) == -1){
            temp.push(array[i]);
        }
    }
    return temp;
}

var data_Country = uniq(params.data.schema[3].data);
var data_year = uniq(params.data.schema[4].data);
data_year = data_year.sort();


//myChart.showLoading();
//myChart.hideLoading();

 var itemStyle = {
     opacity: 0.8,
     shadowBlur: 10,
     shadowOffsetX: 0,
     shadowOffsetY: 0,
     shadowColor: 'rgba(0, 0, 0, 0.5)'
 };

 var sizeFunction = function (x) {
     var y = Math.sqrt(x / 5e8) + 0.1;
     return y * 80;
 };

/*schema 用于tooltip，可以用axes的label获取*/
var schema =[{}];
schema = [
    {name: 'Income', index: 0, text: '人均收入', unit: '美元'},
    {name: 'LifeExpectancy', index: 1, text: '人均寿命', unit: '岁'},
    {name: 'Population', index: 2, text: '总人口', unit: ''},
    {name: 'Country', index: 3, text: '国家', unit: ''}
];

for (var i = 0; i < params.axes.length-1; i++) {
  schema[i].text = params.axes[i].label;
};

var options = {}
var source= [{}];

var id = data_year[0];
 source= params.data.data.filter((item)=>{
return item[4] === id;
 }) ;

option = {
    baseOption :{
      timeline: {
        axisType: 'category',
        orient: 'vertical',
        autoPlay: true,
        inverse: true,
        playInterval: 1000,
        left: null,
        right: 0,
        top: 20,
        bottom: 20,
        width: 55,
        height: null,
        label: {
            color: '#999'
        },
        symbol: 'none',
        lineStyle: {
            color: '#555'
        },
        checkpointStyle: {
            color: '#bbb',
            borderColor: '#777',
            borderWidth: 2
        },
        controlStyle: {
            showNextBtn: false,
            showPrevBtn: false,
            color: '#666',
            borderColor: '#666'
        },
        emphasis: {
            label: {
                color: '#fff'
            },
            controlStyle: {
                color: '#aaa',
                borderColor: '#aaa'
            }
        },
       data: []
     },
    backgroundColor: '#282841',
    title: [{
        text: '1800',
        textAlign: 'center',
        left: '63%',
        top: '55%',
        textStyle: {
            fontSize: 100,
            color: 'rgba(255, 255, 255, 0.7)'
        }
    }, {
        text: '各国人均寿命与GDP关系演变',
        left: 'center',
        top: 10,
        textStyle: {
            color: '#aaa',
            fontWeight: 'normal',
            fontSize: 20
        }
    }],
   tooltip: {
        padding: 5,
        backgroundColor: '#222',
        borderColor: '#777',
        borderWidth: 1,
        formatter: function (obj) {
            var value = obj.value;
            return schema[3].text + '：' + value[3] + '<br>'
                    + schema[1].text + '：' + value[1] + schema[1].unit + '<br>'
                    + schema[0].text + '：' + value[0] + schema[0].unit + '<br>'
                    + schema[2].text + '：' + value[2] + '<br>';
        }
    },
   grid: {
        top: 100,
        containLabel: true,
        left: 30,
        right: '110'
    },
   series:[{   type: 'scatter',
            data: [],
           }],
   xAxis: {
       type: 'log',
       name: '人均收入',
       max: 100000,
       min: 300,
        nameGap: 25,
        nameLocation: 'middle',
        nameTextStyle: {
           fontSize: 18
        },
        splitLine: {
           show: false
        },
        axisLine: {
           lineStyle: {
               color: '#ccc'
           }
        },
       axisLabel: {
          formatter: '{value} $'
       }
   },
   yAxis: {
      type: 'value',
      name: '平均寿命',
      max: 100,
      nameTextStyle: {
          color: '#ccc',
          fontSize: 18
      },
      axisLine: {
          lineStyle: {
              color: '#ccc'
          }
      },
      splitLine: {
          show: false
      },
      axisLabel: {
          formatter: '{value} 岁'
      }
  },
   visualMap: [
  {
      show: false,
      dimension: 3,
      categories: data_Country,
      calculable: true,
      precision: 0.1,
      textGap: 30,
      textStyle: {
          color: '#ccc'
      },
      inRange: {
          color: (function () {
              var colors = ['#58CFFF', '#323FFF', '#7A79FF', '#B8FFF2', '#FF897A', '#FFB0E3', '#FFA45A', '#25B899', '#602FFF', '#EC65B0'];
              return colors.concat(colors);
          })()
      }
  }
  ],
  
  series: [
      {
          type: 'scatter',
          itemStyle: itemStyle,
          data: source,
          symbolSize: function(val) {
              return sizeFunction(val[2]);
          }
      }
  ],
  animationDurationUpdate: 1000,
  animationEasingUpdate: 'quinticInOut'
    
    },
  options: []//end of baseOption
  
};



for (var n = 0; n < data_year.length; n++) {
    option.baseOption.timeline.data.push(data_year[n]);
     id = data_year[n];
     source= params.data.data.filter((item)=>{
    return item[4] === id;
    })
    option.options.push({
        title: {
            show: true,
            'text': data_year[n] + ''
        },
        series: {
            name: data_year[n],
            type: 'scatter',
            itemStyle: itemStyle,
            data: source,
           //symbolSize: function(val) {
           //    return sizeFunction(val[2]);
           //}
        }
    });
}

myChart.setOption(option);



 



/**
 * @typedef {Object} clickOptions
 * @property {string} className  点击事件的当前元素的className
 * @property {string} id 点击事件的当前元素的id
 * @property {number} x 当前鼠标在容器中的横向相对位置
 * @property {number} y 当前鼠标在容器中的纵向相对位置
 * @property {string} data 当前元素的data属性
 */

/**
 * @type {Function} params.bindClickListener 绑定页面点击事件
 * @param {Function} clickHandler 点击页面的处理函数，接收一个参数clickOptions
 */

/**
 * @typedef ClickEventData
 * @param {string} data 维度值
 * @param {string | number} path 维度值对应的轴位置，例：0（第一个轴）； '1.1' (第二个轴的第二个子轴)
 */

/**
 * @type {Function} params.onHSClickHandler 触发衡石交互
 * @param {Array<clickEventData>} clickData 需要传递的数据
 */
